capture program drop textreg_analyze
program textreg_analyze 
	syntax using/ 

    clear
	python: textreg_analyze("`using'")
	compress
end



python

# load necessary python packages
from sfi import Data
import pickle
   

def textreg_analyze( model_path = ""):
    print("Loading Model: {}".format(model_path) )

    with open( model_path  , 'rb') as f:
        cv = pickle.load(f)
        model = pickle.load(f) 

    voc = cv.get_feature_names()
    coef = model.coef_
    num_obs = len(coef)
    
    # path the variables back to stata
    Data.addVarStrL("ngram")
    Data.addVarDouble("coef")
    Data.setObsTotal(num_obs)
    Data.store(var="ngram" , val = voc, obs=None)
    Data.store(var="coef" , val = coef, obs=None)
    

end











